/**
* Loading plugin for jQuery
* version: v1.0.6
* 
* Small helper to give the user a visual feedback that something is happening 
* when fetching/posting data
* 
* USAGE:
* - global overlay:                     $.isLoading();
* - use javascript:                     $( selector ).isLoading();
* - On non-form elements:               $("div").isLoading({ text: "Loading", position:'inside'});
* - remove the loading element:         $( selector ).isLoading( "hide" );
*
* @author Laurent Blanes <laurent.blanes@gmail.com>
* ---
* Copyright 2013, Laurent Blanes ( https://github.com/hekigan/is-loading )
* 
* The MIT License (MIT)
* 
* Copyright (c) 2013 Laurent Blanes
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/(function(e,t,n,r){function o(t,n){this.element=t;this.options=e.extend({},s,n);this._defaults=s;this._name=i;this._loader=null;this.init()}function u(){e[i]||(e.isLoading=function(t){e("body").isLoading(t)})}var i="isLoading",s={position:"right",text:"","class":"icon-refresh",tpl:'<span class="isloading-wrapper %wrapper%">%text%<i class="%class% icon-spin"></i></span>',disableSource:!0,disableOthers:[]};o.prototype={init:function(){e(this.element).is("body")&&(this.options.position="overlay");this.show()},show:function(){var n=this,r=n.options.tpl.replace("%wrapper%"," isloading-show  isloading-"+n.options.position);r=r.replace("%class%",n.options["class"]);r=r.replace("%text%",n.options.text!==""?n.options.text+" ":"");n._loader=e(r);e(n.element).is("input, textarea")&&!0===n.options.disableSource?e(n.element).attr("disabled","disabled"):!0===n.options.disableSource&&e(n.element).addClass("disabled");switch(n.options.position){case"inside":e(n.element).html(n._loader);break;case"overlay":var i=null;if(e(n.element).is("body")){i=e('<div class="isloading-overlay" style="position:fixed; left:0; top:0; z-index: 10000; width: 100%; height: '+e(t).height()+'px;" />');e("body").prepend(i);e(t).on("resize",function(){i.height(e(t).height()+"px");n._loader.css({top:e(t).height()/2-n._loader.outerHeight()/2+"px"})})}else{var s=e(n.element).css("position"),o={},u=e(n.element).outerHeight()+"px",a="100%";"relative"===s||"absolute"===s?o={top:0,left:0}:o=e(n.element).position();i=e('<div class="isloading-overlay" style="position:absolute; top: '+o.top+"px; left: "+o.left+"px; z-index: 10000; width: "+a+"; height: "+u+';" />');e(n.element).prepend(i);e(t).on("resize",function(){i.height(e(n.element).outerHeight()+"px");n._loader.css({top:i.outerHeight()/2-n._loader.outerHeight()/2+"px"})})}i.html(n._loader);n._loader.css({top:i.outerHeight()/2-n._loader.outerHeight()/2+"px"});break;default:e(n.element).after(n._loader)}n.disableOthers()},hide:function(){if("overlay"===this.options.position)e(this.element).find(".isloading-overlay").first().remove();else{e(this._loader).remove();e(this.element).text(e(this.element).attr("data-isloading-label"))}e(this.element).removeAttr("disabled").removeClass("disabled");this.enableOthers()},disableOthers:function(){e.each(this.options.disableOthers,function(t,n){var r=e(n);r.is("button, input, textarea")?r.attr("disabled","disabled"):r.addClass("disabled")})},enableOthers:function(){e.each(this.options.disableOthers,function(t,n){var r=e(n);r.is("button, input, textarea")?r.removeAttr("disabled"):r.removeClass("disabled")})}};e.fn[i]=function(t){return this.each(function(){if(t&&"hide"!==t||!e.data(this,"plugin_"+i))e.data(this,"plugin_"+i,new o(this,t));else{var n=e.data(this,"plugin_"+i);"hide"===t?n.hide():n.show()}})};u()})(jQuery,window,document);
